title 'Document SAS datasets';
x 'cd c:\Active\Asset Pricing 2003\AP11\Liquidity Distribution\v01';
libname sasds '.\Sas Datasets';
options nocenter ls=100 ps=max sasautos='.';
title ' ';

***************************************************************************************************
	permnosamplecomparison describes the comparison sample. 
	There are approx 250 firms (permnos) per year 1993-2003.
	It is constructed from and contains various crsp fields.
	The ticker symbol on this file is used to match TAQ.
***************************************************************************************************;
proc contents data=sasds.permnosamplecomparison;
%Printds(sasds.permnosamplecomparison);	*	Printds is a macro that prints a bit of the dataset;

***************************************************************************************************
	dayfile is constructed from taq data.
	There is one record per day per firm (in the comparison sample).
***************************************************************************************************;
proc datasets lib=sasds;
	modify dayfile;	*	add some additional labels;
	label
		dVol='Daily dollar volume'
		tSign='Net number of signed trades'
		tSignDVol='Net signed dollar volume'
		tSignSqrtDVol='Net signed square root dollar volume'
		spread='Time-wtd avg spread'
		logspread='Time-wtd avg log spread';
		nT='Number of trades';
proc contents data=sasds.dayfile;
%Printds(sasds.dayfile);

***************************************************************************************************
	monfile is constructed from taq data.
	There is one record per month per firm (in the comparison sample).
***************************************************************************************************;
proc datasets lib=sasds;
	modify monfile;
	format date monyy7.;
proc contents data=sasds.monfile;
%Printds(sasds.monfile);

***************************************************************************************************
	estfile is constructed from taq data and contains estimates of price impact regressions,
	where the aggregation period is 5 minutes.
	There is one record per firm per month per specification.
	Specifications are indexed by _MODEL_: _MODEL_=m1, m2, ..., m8
	The eight specifications are:
		m1: model dlogBAM=tSign / noint
		m2: model dlogBAM=tSignSqrtDVol / noint
		m3: model dlogBAM=tSign tSignSqrtDVol / noint
		m4: model dlogBAM=tSign tSignDVol / noint
		m5: model dBAM=tSign / noint
		m6: model dBAM=tSignSqrtDVol / noint
		m7: model dBAM=tSign tSignSqrtDVol / noint
		m8: model dBAM=tSign tSignDVol / noint
	where 
		dlogBAM is the change in the log bid-ask midpoint
		dBAM is the change in the bid-ask midpoint ($/share)
	Each record in estfile reports the estimated coefficient(s), R2's, etc.
	The variable _EDF_ ("error degrees of freedom") is approx the number of obs in
	the estimation. For low-cap stocks, many of the intervals have no trade and no price change.
	The variable nRegressionObsNonzero contains the number of intervals for which there was either
	a trade on a non-zero price change. Estimates with a low nRegressionObsNonzero should
	probably not be used.
***************************************************************************************************;
proc datasets lib=sasds;
	modify estfile;
	format date monyy7.;
proc contents data=sasds.estfile;
%Printds(sasds.estfile);
